#version 430 core
 
layout(triangles, fractional_odd_spacing, ccw) in;
 
layout (location = 0) in vec2  tessTexCoords[];
layout (location = 1) in vec4  tessPosition[];
layout (location = 2) in vec2  tessNoiseCoords[];
layout (location = 3) in vec3  tessNormal[];

layout (location = 0) out vec2  geoTexCoords;
layout (location = 1) out vec4  geoPosition;
layout (location = 2) out float  geoCrackDepth;
layout (location = 3) out float  geoResourceType;

// matrices for drawing shit

uniform int modelID;
uniform int planetType;

layout(binding = 0, rgba32f) uniform readonly restrict image2D inputTex;
layout (binding = 4) uniform sampler2D heightTexture;

float getNoise(ivec2 Coords){

	float noise = texelFetch(heightTexture, Coords, 0).r;

	return noise;
}

float hash(float n) { return fract(sin(n) * 1e4); }
float hash(vec2 p) { return fract(1e4 * sin(17.0 * p.x + p.y * 0.1) * (0.1 + abs(sin(p.y * 13.0 + p.x)))); }

float noise(vec3 x) {
	const vec3 step = vec3(110, 241, 171);

	vec3 i = floor(x);
	vec3 f = fract(x);
 
	// For performance, compute the base input to a 1D hash from the integer part of the argument and the 
	// incremental change to the 1D based on the 3D -> 1D wrapping
    float n = dot(i, step);

	vec3 u = f * f * (3.0 - 2.0 * f);
	return mix(mix(mix( hash(n + dot(step, vec3(0, 0, 0))), hash(n + dot(step, vec3(1, 0, 0))), u.x),
                   mix( hash(n + dot(step, vec3(0, 1, 0))), hash(n + dot(step, vec3(1, 1, 0))), u.x), u.y),
               mix(mix( hash(n + dot(step, vec3(0, 0, 1))), hash(n + dot(step, vec3(1, 0, 1))), u.x),
                   mix( hash(n + dot(step, vec3(0, 1, 1))), hash(n + dot(step, vec3(1, 1, 1))), u.x), u.y), u.z);
}

#define NUM_OCTAVES 5

float fbm ( in vec3 _st) {
    float v = 0.0;
    float a = 0.5;
    vec3 shift = vec3(100.0);
    // Rotate to reduce axial bias
    mat2 rot = mat2(cos(0.5), sin(0.5),
                    -sin(0.5), cos(0.50));
    for (int i = 0; i < NUM_OCTAVES; ++i) {
        v += a * noise(_st);
        _st = _st * 2.0 + shift;
        a *= 0.5;
    }
    return v;
}


void main()
{ 
	

	int instanceNumber = 0;
	float frequency = 5.0f;

	vec2 texCoords = tessTexCoords[0] * gl_TessCoord.x + tessTexCoords[1] * gl_TessCoord.y + tessTexCoords[2] * gl_TessCoord.z; 
	vec2 noiseCoords = tessNoiseCoords[0] * gl_TessCoord.x + tessNoiseCoords[1] * gl_TessCoord.y + tessNoiseCoords[2] * gl_TessCoord.z; 

	vec3 normalAtLocation = normalize(tessNormal[0] * gl_TessCoord.x + tessNormal[1] * gl_TessCoord.y + tessNormal[2] * gl_TessCoord.z); 


	geoTexCoords = texCoords;

	vec3 pos = tessPosition[0].xyz * gl_TessCoord.x + tessPosition[1].xyz * gl_TessCoord.y + tessPosition[2].xyz * gl_TessCoord.z; 

	float radius = length(pos);
	float heightMulti = 2.0;
	float height = 0.0;
	vec4 worldPos;


	//convert the resourceEnum into -1 / 1:


	if(length(pos) < 101.0){
		geoResourceType = 0.0;
	}else{
		geoResourceType = (texture(heightTexture, noiseCoords).g * 2.0) - 1.0;
	}

	if(abs(geoResourceType) < 0.1){
		geoResourceType = 0.0;
	}

	float noiseVal = texture(heightTexture, noiseCoords).r;

	noiseVal -= 0.5;
	noiseVal *= 2.0;

	geoCrackDepth = 0.0;

	if(noiseVal > 0.0){
		heightMulti = 1.5;
	}else{
		heightMulti = 4.0;

		geoCrackDepth = abs(noiseVal);
	}

	height = noiseVal;

	pos = pos + normalAtLocation * (height * heightMulti - 1.0 - abs(geoResourceType) * 3.0); //basedrop + terrain height adjustment + resourceHeight adjustment

	worldPos = vec4(pos, 1.0);

	gl_Position = worldPos;
	geoPosition = worldPos;
}

